<?php
require_once __DIR__ . '/config.php'; $pdo = db();
$erro=''; $ok='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['add']) && trim($_POST['nome'])!==''){
    try{$pdo->prepare("INSERT INTO contas (nome, ativa) VALUES (?,1)")->execute([trim($_POST['nome'])]);$ok='Conta criada.';}catch(Exception $e){$erro='Erro ao criar: '.$e->getMessage();}
  }
  if(isset($_POST['rename']) && (int)$_POST['id']>0 && trim($_POST['nome'])!==''){
    try{$pdo->prepare("UPDATE contas SET nome=? WHERE id=?")->execute([trim($_POST['nome']),(int)$_POST['id']]);$ok='Conta renomeada.';}catch(Exception $e){$erro='Erro ao renomear: '.$e->getMessage();}
  }
  if(isset($_POST['toggle']) && (int)$_POST['id']>0){
    try{$pdo->prepare("UPDATE contas SET ativa=1-ativa WHERE id=?")->execute([(int)$_POST['id']]);$ok='Status atualizado.';}catch(Exception $e){$erro='Erro ao atualizar: '.$e->getMessage();}
  }
  if(isset($_POST['delete']) && (int)$_POST['id']>0){
    try{$chk=$pdo->prepare("SELECT COUNT(*) c FROM lancamentos WHERE conta_id=?");$chk->execute([(int)$_POST['id']]);$c=(int)$chk->fetch()['c'];
      if($c>0){$erro='Não é possível excluir: há lançamentos vinculados.';}
      else{$pdo->prepare("DELETE FROM contas WHERE id=?")->execute([(int)$_POST['id']]);$ok='Conta excluída.';}
    }catch(Exception $e){$erro='Erro ao excluir: '.$e->getMessage();}
  }
}
$rows=$pdo->query("SELECT * FROM contas ORDER BY ativa DESC, nome ASC")->fetchAll();
?><!doctype html><html lang="pt-br"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Contas</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body class="bg-light"><div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3"><h1 class="mb-0">Contas</h1><div class="d-flex gap-2"><a href="index.php" class="btn btn-secondary">← Lançamentos</a><a href="transfers.php" class="btn btn-outline-secondary">Transferências</a><a href="reports.php" class="btn btn-outline-secondary">Relatórios</a></div></div>
  <?php if($erro): ?><div class="alert alert-danger"><?= h($erro) ?></div><?php endif; ?>
  <?php if($ok): ?><div class="alert alert-success"><?= h($ok) ?></div><?php endif; ?>

  <div class="card mb-3"><div class="card-header">Nova Conta</div><div class="card-body">
    <form method="post" class="row g-2">
      <div class="col-md-6"><input class="form-control" name="nome" placeholder="Ex.: Conta Bradesco" required></div>
      <div class="col-auto"><button class="btn btn-success" name="add" value="1">Adicionar</button></div>
    </form>
  </div></div>

  <div class="card"><div class="card-header">Lista de Contas</div>
    <div class="table-responsive"><table class="table table-striped mb-0 align-middle">
      <thead><tr><th>#</th><th>Nome</th><th>Status</th><th class="text-end">Ações</th></tr></thead><tbody>
      <?php foreach($rows as $r): ?>
        <tr><td><?= (int)$r['id'] ?></td><td><?= h($r['nome']) ?></td>
        <td><?= $r['ativa']?'<span class="badge text-bg-success">Ativa</span>':'<span class="badge text-bg-secondary">Inativa</span>' ?></td>
        <td class="text-end">
          <form method="post" class="d-inline-flex gap-1">
            <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
            <input class="form-control form-control-sm" name="nome" value="<?= h($r['nome']) ?>" style="width:240px">
            <button class="btn btn-sm btn-outline-primary" name="rename" value="1">Renomear</button>
            <button class="btn btn-sm btn-outline-warning" name="toggle" value="1"><?= $r['ativa']?'Inativar':'Ativar' ?></button>
            <button class="btn btn-sm btn-outline-danger" name="delete" value="1" onclick="return confirm('Excluir definitivamente?')">Excluir</button>
          </form>
        </td></tr>
      <?php endforeach; ?>
      </tbody></table></div>
  </div>
</div></body></html>
