<?php
require_once __DIR__ . '/config.php'; // já define h(), db(), etc.
$pdo = db();

// Helpers locais (sem colidir com o config.php)
if (!function_exists('fmtIn')) {
  function fmtIn($v){ return str_replace(',', '.', trim($v)); }
}
if (!function_exists('fmtOut')) {
  function fmtOut($n){ return number_format((float)$n,2,',','.'); }
}

$contas = $pdo->query("SELECT id,nome FROM contas WHERE ativa=1 ORDER BY nome")->fetchAll();

$ini = isset($_GET['ini']) ? $_GET['ini'] : date('Y-m-01');
$fim = isset($_GET['fim']) ? $_GET['fim'] : date('Y-m-t');
$conta_id = isset($_GET['conta_id']) && $_GET['conta_id']!=='' ? (int)$_GET['conta_id'] : null;
$q = trim($_GET['q'] ?? '');

$msg = '';

// UPDATE
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action'] ?? '') === 'update') {
  $id = (int)$_POST['id'];
  $data = $_POST['data'] ?? date('Y-m-d');
  $descricao = trim($_POST['descricao'] ?? '');
  $valor = (float)fmtIn($_POST['valor'] ?? '0');
  $tipo = (($_POST['tipo'] ?? 'despesa')==='receita') ? 'receita' : 'despesa';
  $recorrente = isset($_POST['recorrente']) ? 1 : 0;
  $conta = isset($_POST['conta_id']) && $_POST['conta_id']!=='' ? (int)$_POST['conta_id'] : null;
  $transferencia = isset($_POST['transferencia']) ? 1 : 0;

  try{
    $stmt = $pdo->prepare("UPDATE lancamentos SET data=?, descricao=?, valor=?, tipo=?, recorrente=?, conta_id=?, transferencia=? WHERE id=?");
    $stmt->execute([$data,$descricao,$valor,$tipo,$recorrente,$conta,$transferencia,$id]);
    $msg = 'Registro #'.$id.' atualizado.';
  }catch(Exception $e){ $msg = 'Erro ao atualizar: '.$e->getMessage(); }
}

// DELETE
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action'] ?? '') === 'delete') {
  $id = (int)$_POST['id'];
  try{
    $pdo->prepare("DELETE FROM lancamentos WHERE id=?")->execute([$id]);
    $msg = 'Registro #'.$id.' apagado.';
  }catch(Exception $e){ $msg = 'Erro ao apagar: '.$e->getMessage(); }
}

// Consulta
$w = " WHERE data BETWEEN ? AND ? ";
$par = [$ini,$fim];
if ($conta_id) { $w.=" AND (conta_id = ?)"; $par[]=$conta_id; }
if ($q!==''){ $w.=" AND (descricao LIKE ?)"; $par[]='%'.$q.'%'; }

$sql = "SELECT * FROM lancamentos ".$w." ORDER BY data DESC, id DESC LIMIT 500";
$st = $pdo->prepare($sql); $st->execute($par); $rows = $st->fetchAll();
?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Editar/Apagar Lançamentos</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>.mini{font-size:.85rem}</style>
</head>
<body class="bg-light">
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="mb-0">Editar / Apagar</h1>
    <div class="d-flex gap-2">
      <a href="index.php" class="btn btn-secondary">← Lançamentos</a>
      <a href="transfers.php" class="btn btn-outline-secondary">Transferências</a>
      <a href="reports.php" class="btn btn-outline-secondary">Relatórios</a>
    </div>
  </div>

  <?php if($msg): ?><div class="alert alert-info py-2"><?= h($msg) ?></div><?php endif; ?>

  <form class="row g-2 mb-3" method="get">
    <div class="col-auto">
      <label class="form-label">Início</label>
      <input type="date" name="ini" class="form-control" value="<?= h($ini) ?>">
    </div>
    <div class="col-auto">
      <label class="form-label">Fim</label>
      <input type="date" name="fim" class="form-control" value="<?= h($fim) ?>">
    </div>
    <div class="col-auto">
      <label class="form-label">Conta</label>
      <select name="conta_id" class="form-select">
        <option value="">Todas</option>
        <?php foreach($contas as $c): ?>
          <option value="<?= (int)$c['id'] ?>" <?= $conta_id===(int)$c['id']?'selected':'' ?>><?= h($c['nome']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-auto">
      <label class="form-label">Descrição contém</label>
      <input type="text" name="q" class="form-control" value="<?= h($q) ?>" placeholder="texto livre">
    </div>
    <div class="col-auto align-self-end">
      <button class="btn btn-primary">Buscar</button>
    </div>
  </form>

  <div class="card">
    <div class="card-header">Resultados (máx. 500)</div>
    <div class="table-responsive">
      <table class="table table-sm align-middle mb-0">
        <thead class="mini">
          <tr>
            <th>ID</th><th>Data</th><th>Descrição</th><th>Valor</th><th>Tipo</th><th>Rec</th><th>Conta</th><th>Transf</th><th style="width:180px">Ações</th>
          </tr>
        </thead>
        <tbody class="mini">
          <?php foreach($rows as $r): ?>
            <tr>
              <form method="post">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <td class="text-muted">#<?= (int)$r['id'] ?></td>
                <td><input type="date" name="data" class="form-control form-control-sm" value="<?= h($r['data']) ?>"></td>
                <td><input type="text" name="descricao" class="form-control form-control-sm" value="<?= h($r['descricao']) ?>"></td>
                <td><input type="text" name="valor" class="form-control form-control-sm" value="<?= h(fmtOut($r['valor'])) ?>"></td>
                <td>
                  <select name="tipo" class="form-select form-select-sm">
                    <option value="despesa" <?= $r['tipo']==='despesa'?'selected':'' ?>>despesa</option>
                    <option value="receita" <?= $r['tipo']==='receita'?'selected':'' ?>>receita</option>
                  </select>
                </td>
                <td class="text-center">
                  <input type="checkbox" name="recorrente" <?= (int)$r['recorrente']===1?'checked':'' ?>>
                </td>
                <td>
                  <select name="conta_id" class="form-select form-select-sm">
                    <option value="">(Sem conta)</option>
                    <?php foreach($contas as $c): ?>
                      <option value="<?= (int)$c['id'] ?>" <?= (int)$r['conta_id']===(int)$c['id']?'selected':'' ?>><?= h($c['nome']) ?></option>
                    <?php endforeach; ?>
                  </select>
                </td>
                <td class="text-center">
                  <input type="checkbox" name="transferencia" <?= (int)$r['transferencia']===1?'checked':'' ?>>
                </td>
                <td>
                  <div class="d-flex gap-1">
                    <button name="action" value="update" class="btn btn-sm btn-primary">Salvar</button>
                    <button name="action" value="delete" class="btn btn-sm btn-danger" onclick="return confirm('Apagar registro #<?= (int)$r['id'] ?>?')">Apagar</button>
                  </div>
                </td>
              </form>
            </tr>
          <?php endforeach; ?>
          <?php if(!$rows): ?>
            <tr><td colspan="9" class="text-center text-muted py-3">Nada encontrado.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

</div>
</body>
</html>
