<?php
require_once __DIR__ . '/config.php'; 
$pdo = db();

$mes = isset($_GET['mes']) ? (int)$_GET['mes'] : (int)date('m');
$ano = isset($_GET['ano']) ? (int)$_GET['ano'] : (int)date('Y');
$contaFiltro = isset($_GET['conta_id']) && $_GET['conta_id'] !== '' ? (int)$_GET['conta_id'] : null;

$contas = $pdo->query("SELECT id, nome FROM contas WHERE ativa = 1 ORDER BY nome")->fetchAll();

/* =========================
   NOVO LANÇAMENTO MANUAL
   ========================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add'])) {
  $data       = $_POST['data'] ?? date('Y-m-d');
  $descricao  = trim($_POST['descricao'] ?? '');
  $valor      = (float) str_replace(',', '.', $_POST['valor'] ?? '0');
  $tipo       = (isset($_POST['tipo']) && $_POST['tipo'] === 'receita') ? 'receita' : 'despesa';
  $recorrente = isset($_POST['recorrente']) ? 1 : 0;
  $conta_id   = isset($_POST['conta_id']) && $_POST['conta_id'] !== '' ? (int)$_POST['conta_id'] : null;

  if ($descricao !== '' && $valor != 0) {
    // transferencia = 0 (lançamento normal)
    $pdo->prepare("
      INSERT INTO lancamentos (data, descricao, valor, tipo, recorrente, conta_id, fonte, transferencia)
      VALUES (?, ?, ?, ?, ?, ?, 'manual', 0)
    ")->execute([$data, $descricao, $valor, $tipo, $recorrente, $conta_id]);

    header("Location: index.php?mes=$mes&ano=$ano&conta_id=" . ($contaFiltro !== null ? $contaFiltro : ''));
    exit;
  }
}

/* ===================================
   GERAR LANÇAMENTOS RECORRENTES (mês)
   =================================== */
if (isset($_POST['gerar_recorrentes'])) {
  $inicio = sprintf('%04d-%02d-01', $ano, $mes);
  $fim    = date('Y-m-t', strtotime($inicio));

  $models = $pdo->query("
    SELECT descricao, tipo, valor, conta_id
    FROM lancamentos
    WHERE recorrente = 1
    GROUP BY descricao, tipo, valor, conta_id
  ")->fetchAll();

  foreach ($models as $m) {
    $whereConta = $m['conta_id'] ? " AND conta_id=" . (int)$m['conta_id'] : " AND conta_id IS NULL";
    $chk = $pdo->prepare("
      SELECT COUNT(*) c
      FROM lancamentos
      WHERE descricao = ? AND tipo = ? AND recorrente = 1
        {$whereConta}
        AND data BETWEEN ? AND ?
    ");
    $chk->execute([$m['descricao'], $m['tipo'], $inicio, $fim]);
    $row = $chk->fetch();
    $exists = (int)$row['c'] > 0;

    if (!$exists) {
      // transferencia = 0 (normal)
      $pdo->prepare("
        INSERT INTO lancamentos (data, descricao, valor, tipo, recorrente, conta_id, fonte, transferencia)
        VALUES (?, ?, ?, ?, 1, ?, 'manual', 0)
      ")->execute([$inicio, $m['descricao'], $m['valor'], $m['tipo'], $m['conta_id']]);
    }
  }

  header("Location: index.php?mes=$mes&ano=$ano&conta_id=" . ($contaFiltro !== null ? $contaFiltro : ''));
  exit;
}

/* =========================
   BUSCA DO PERÍODO
   ========================= */
$inicio = sprintf('%04d-%02d-01', $ano, $mes);
$fim    = date('Y-m-t', strtotime($inicio));

$whereConta = $contaFiltro !== null ? " AND conta_id = " . $contaFiltro : "";
$stmt = $pdo->prepare("
  SELECT *
  FROM lancamentos
  WHERE data BETWEEN ? AND ?
    {$whereConta}
  ORDER BY data ASC, id ASC
");
$stmt->execute([$inicio, $fim]);
$rows = $stmt->fetchAll();

/* ===========================================================
   TOTAIS DO MÊS (transferências NÃO entram em receitas/despesas,
   mas entram no saldo por conta)
   =========================================================== */
$total_receitas = 0.0;      // receitas "normais" (transferencia=0)
$total_despesas = 0.0;      // despesas "normais" (transferencia=0)
$transf_in_mes  = 0.0;      // transferências (receita) - crédito
$transf_out_mes = 0.0;      // transferências (despesa) - débito

foreach ($rows as $r) {
  $v = (float)$r['valor'];

  if ((int)$r['transferencia'] === 1) {
    // Transferências não entram nos totais de receitas/despesas,
    // mas impactam o saldo da conta ao calcular saldo_mes
    if ($r['tipo'] === 'receita') $transf_in_mes  += $v;
    if ($r['tipo'] === 'despesa') $transf_out_mes += $v;
    continue;
  }

  if ($r['tipo'] === 'receita') $total_receitas += $v;
  if ($r['tipo'] === 'despesa') $total_despesas += $v;
}

// Saldo do mês considera transferências (movimentação entre contas)
$saldo_mes = ($total_receitas - $total_despesas) + ($transf_in_mes - $transf_out_mes);

/* ===========================================================
   SALDO ANTERIOR (antes do 1º dia do mês)
   - receitas/despesas normais
   - + transf de entrada / - transf de saída
   =========================================================== */
if ($contaFiltro !== null) {
  // Receitas/Despesas normais (transferencia = 0)
  $q1 = $pdo->prepare("SELECT COALESCE(SUM(valor),0) s FROM lancamentos
                       WHERE data < ? AND conta_id = ? AND transferencia = 0 AND tipo = 'receita'");
  $q1->execute([$inicio, $contaFiltro]);
  $prev_rec_norm = (float)$q1->fetch()['s'];

  $q2 = $pdo->prepare("SELECT COALESCE(SUM(valor),0) s FROM lancamentos
                       WHERE data < ? AND conta_id = ? AND transferencia = 0 AND tipo = 'despesa'");
  $q2->execute([$inicio, $contaFiltro]);
  $prev_desp_norm = (float)$q2->fetch()['s'];

  // Transferências (entram no saldo, não nos totais de receitas/despesas)
  $q3 = $pdo->prepare("SELECT COALESCE(SUM(valor),0) s FROM lancamentos
                       WHERE data < ? AND conta_id = ? AND transferencia = 1 AND tipo = 'receita'");
  $q3->execute([$inicio, $contaFiltro]);
  $prev_transf_in = (float)$q3->fetch()['s'];

  $q4 = $pdo->prepare("SELECT COALESCE(SUM(valor),0) s FROM lancamentos
                       WHERE data < ? AND conta_id = ? AND transferencia = 1 AND tipo = 'despesa'");
  $q4->execute([$inicio, $contaFiltro]);
  $prev_transf_out = (float)$q4->fetch()['s'];
} else {
  // Todas as contas
  $q1 = $pdo->prepare("SELECT COALESCE(SUM(valor),0) s FROM lancamentos
                       WHERE data < ? AND transferencia = 0 AND tipo = 'receita'");
  $q1->execute([$inicio]);
  $prev_rec_norm = (float)$q1->fetch()['s'];

  $q2 = $pdo->prepare("SELECT COALESCE(SUM(valor),0) s FROM lancamentos
                       WHERE data < ? AND transferencia = 0 AND tipo = 'despesa'");
  $q2->execute([$inicio]);
  $prev_desp_norm = (float)$q2->fetch()['s'];

  $q3 = $pdo->prepare("SELECT COALESCE(SUM(valor),0) s FROM lancamentos
                       WHERE data < ? AND transferencia = 1 AND tipo = 'receita'");
  $q3->execute([$inicio]);
  $prev_transf_in = (float)$q3->fetch()['s'];

  $q4 = $pdo->prepare("SELECT COALESCE(SUM(valor),0) s FROM lancamentos
                       WHERE data < ? AND transferencia = 1 AND tipo = 'despesa'");
  $q4->execute([$inicio]);
  $prev_transf_out = (float)$q4->fetch()['s'];
}

// Saldo anterior considera transferências
$saldo_anterior = ($prev_rec_norm - $prev_desp_norm) + ($prev_transf_in - $prev_transf_out);

// Saldo geral = saldo anterior + saldo do mês
$saldo_geral = $saldo_anterior + $saldo_mes;

/* =========================
   Helpers
   ========================= */
function contaNome($id, $contas) {
  foreach ($contas as $c) { if ($c['id'] == $id) return $c['nome']; }
  return '';
}
?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Controle de Despesas</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
  .badge-rec{background:#6f42c1}
  .badge-transf{background:#0dcaf0}
  .small-hint{font-size:.9rem;color:#6c757d}
  .action-col{width:200px}
</style>
</head>
<body class="bg-light">
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <h1 class="mb-0">Controle de Despesas</h1>
    <div class="d-flex gap-2">
      <a href="contas.php" class="btn btn-outline-secondary">Contas</a>
      <a href="transfers.php" class="btn btn-outline-secondary">Transferências</a>
      <a href="reports.php" class="btn btn-outline-secondary">Relatórios</a>
    </div>
  </div>
  <div class="small-hint mb-3">
    Lance por <strong>Conta</strong>, mova valores em <strong>Transferências</strong>, e veja o <strong>Relatório</strong> mensal/por ano.
  </div>

  <form class="row g-2 mb-3" method="get">
    <div class="col-auto">
      <label class="form-label">Conta</label>
      <select name="conta_id" class="form-select">
        <option value="">Todas</option>
        <?php foreach($contas as $c): ?>
          <option value="<?= (int)$c['id'] ?>" <?= $contaFiltro === (int)$c['id'] ? 'selected' : '' ?>>
            <?= h($c['nome']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-auto">
      <label class="form-label">Mês</label>
      <select name="mes" class="form-select">
        <?php for($m=1;$m<=12;$m++): ?>
          <option value="<?= $m ?>" <?= $m==$mes?'selected':'' ?>><?= $m ?></option>
        <?php endfor; ?>
      </select>
    </div>
    <div class="col-auto">
      <label class="form-label">Ano</label>
      <input type="number" name="ano" class="form-control" value="<?= $ano ?>">
    </div>
    <div class="col-auto align-self-end">
      <button class="btn btn-primary">Filtrar</button>
    </div>
    <div class="col-auto align-self-end">
      <form method="post">
        <button
          formaction="index.php?mes=<?= $mes ?>&ano=<?= $ano ?>&conta_id=<?= $contaFiltro!==null?$contaFiltro:'' ?>"
          name="gerar_recorrentes" value="1"
          class="btn btn-outline-secondary">
          Gerar recorrentes do mês
        </button>
      </form>
    </div>
  </form>

  <div class="row g-3">
    <div class="col-lg-5">
      <div class="card">
        <div class="card-header">Novo Lançamento</div>
        <div class="card-body">
          <form method="post">
            <div class="mb-2">
              <label class="form-label">Conta</label>
              <select name="conta_id" class="form-select">
                <option value="">(Sem conta)</option>
                <?php foreach($contas as $c): ?>
                  <option value="<?= (int)$c['id'] ?>" <?= $contaFiltro===(int)$c['id']?'selected':'' ?>>
                    <?= h($c['nome']) ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="mb-2">
              <label class="form-label">Data</label>
              <input type="date" name="data" class="form-control" value="<?= date('Y-m-d') ?>">
            </div>
            <div class="mb-2">
              <label class="form-label">Descrição</label>
              <input type="text" name="descricao" class="form-control" required>
            </div>
            <div class="row">
              <div class="col-6 mb-2">
                <label class="form-label">Valor (ex: 10,50)</label>
                <input type="text" name="valor" class="form-control" required>
              </div>
              <div class="col-6 mb-2">
                <label class="form-label">Tipo</label>
                <select name="tipo" class="form-select">
                  <option value="despesa">Despesa</option>
                  <option value="receita">Receita</option>
                </select>
              </div>
            </div>
            <div class="form-check mb-2">
              <input class="form-check-input" type="checkbox" name="recorrente" id="rec">
              <label class="form-check-label" for="rec">Recorrente (mensal)</label>
            </div>
            <button type="submit" name="add" value="1" class="btn btn-success">Salvar</button>
          </form>
        </div>
      </div>
    </div>

    <div class="col-lg-7">
      <div class="card">
        <div class="card-header d-flex justify-content-between">
          <span>
            Lançamentos de <?= sprintf('%02d/%04d', $mes, $ano) ?>
            <?= $contaFiltro!==null ? ' — Conta: ' . h(contaNome($contaFiltro, $contas)) : '' ?>
          </span>
          <div class="d-flex flex-wrap gap-2">
            <span class="badge text-bg-secondary">Saldo Ant.: R$ <?= number_format($saldo_anterior, 2, ',', '.') ?></span>
            <span class="badge text-bg-success">Receitas: R$ <?= number_format($total_receitas, 2, ',', '.') ?></span>
            <span class="badge text-bg-danger">Despesas: R$ <?= number_format($total_despesas, 2, ',', '.') ?></span>
            <span class="badge text-bg-primary">Saldo Mês: R$ <?= number_format($saldo_mes, 2, ',', '.') ?></span>
            <span class="badge text-bg-dark">Saldo Geral: R$ <?= number_format($saldo_geral, 2, ',', '.') ?></span>
          </div>
        </div>

        <div class="table-responsive">
          <table class="table table-striped align-middle mb-0">
            <thead>
              <tr>
                <th>Data</th><th>Descrição</th><th>Conta</th><th>Tipo</th><th>Valor</th><th>Rec./Transf.</th><th class="action-col">Ações</th>
              </tr>
            </thead>
            <tbody>
            <?php foreach($rows as $r): $nome = contaNome($r['conta_id'], $contas); ?>
              <tr
                data-id="<?= $r['id'] ?>"
                data-data="<?= h($r['data']) ?>"
                data-descricao="<?= h($r['descricao']) ?>"
                data-tipo="<?= h($r['tipo']) ?>"
                data-valor="<?= number_format((float)$r['valor'], 2, ',', '.') ?>"
                data-recorrente="<?= (int)$r['recorrente'] ?>"
                data-conta-id="<?= isset($r['conta_id']) ? (int)$r['conta_id'] : '' ?>"
              >
                <td><?= date('d/m/Y', strtotime($r['data'])) ?></td>
                <td><?= h($r['descricao']) ?></td>
                <td><?= h($nome ?: '(Sem conta)') ?></td>
                <td>
                  <span class="badge <?= $r['tipo']==='receita' ? 'text-bg-success' : 'text-bg-danger' ?>">
                    <?= h($r['tipo']) ?>
                  </span>
                </td>
                <td>R$ <?= number_format((float)$r['valor'], 2, ',', '.') ?></td>
                <td>
                  <?= $r['recorrente'] ? '<span class="badge badge-rec">R</span>' : '' ?>
                  <?= $r['transferencia'] ? '<span class="badge badge-transf">T</span>' : '' ?>
                </td>
                <td>
                  <button class="btn btn-sm btn-outline-primary btn-edit">Editar</button>
                  <button class="btn btn-sm btn-outline-danger btn-del">Apagar</button>
                </td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>

      </div>
    </div>
  </div>

  <div class="mt-3 d-flex gap-2">
    <a class="btn btn-outline-dark"
       href="export_csv.php?mes=<?= $mes ?>&ano=<?= $ano ?>&conta_id=<?= $contaFiltro!==null?$contaFiltro:'' ?>">
      Exportar CSV
    </a>
  </div>
</div>

<!-- Modal edição -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog"><div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title">Editar Lançamento</h5>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <div class="modal-body">
      <form id="editForm">
        <input type="hidden" name="id" id="edit-id">
        <div class="mb-2">
          <label class="form-label">Conta</label>
          <select class="form-select" name="conta_id" id="edit-conta_id">
            <option value="">(Sem conta)</option>
            <?php foreach($contas as $c): ?>
              <option value="<?= (int)$c['id'] ?>"><?= h($c['nome']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="mb-2">
          <label class="form-label">Data</label>
          <input type="date" class="form-control" name="data" id="edit-data">
        </div>
        <div class="mb-2">
          <label class="form-label">Descrição</label>
          <input type="text" class="form-control" name="descricao" id="edit-descricao">
        </div>
        <div class="row">
          <div class="col-6 mb-2">
            <label class="form-label">Valor</label>
            <input type="text" class="form-control" name="valor" id="edit-valor" placeholder="ex: 10,50">
          </div>
          <div class="col-6 mb-2">
            <label class="form-label">Tipo</label>
            <select class="form-select" name="tipo" id="edit-tipo">
              <option value="despesa">Despesa</option>
              <option value="receita">Receita</option>
            </select>
          </div>
        </div>
        <div class="form-check">
          <input class="form-check-input" type="checkbox" name="recorrente" id="edit-recorrente">
          <label class="form-check-label" for="edit-recorrente">Recorrente (mensal)</label>
        </div>
      </form>
    </div>
    <div class="modal-footer">
      <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
      <button type="button" id="btn-save-edit" class="btn btn-primary">Salvar mudanças</button>
    </div>
  </div></div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function formToFD(obj){const fd=new FormData();for(const k in obj){fd.append(k,obj[k]);}return fd;}

document.querySelectorAll('.btn-edit').forEach(function(btn){
  btn.addEventListener('click',function(){
    var tr=btn.closest('tr');
    document.getElementById('edit-id').value        = tr.dataset.id;
    document.getElementById('edit-data').value      = tr.dataset.data;
    document.getElementById('edit-descricao').value = tr.dataset.descricao;
    document.getElementById('edit-valor').value     = tr.dataset.valor;
    document.getElementById('edit-tipo').value      = tr.dataset.tipo;
    document.getElementById('edit-recorrente').checked = tr.dataset.recorrente==='1';
    document.getElementById('edit-conta_id').value  = tr.dataset.contaId || '';
    var modal=new bootstrap.Modal(document.getElementById('editModal'));
    modal.show();
  });
});

document.getElementById('btn-save-edit').addEventListener('click',async function(){
  var data={
    id:document.getElementById('edit-id').value,
    data:document.getElementById('edit-data').value,
    descricao:document.getElementById('edit-descricao').value,
    valor:document.getElementById('edit-valor').value,
    tipo:document.getElementById('edit-tipo').value,
    recorrente:document.getElementById('edit-recorrente').checked?'1':'0',
    conta_id:document.getElementById('edit-conta_id').value
  };
  try{
    const resp=await fetch('update_full.php',{method:'POST',body:formToFD(data)});
    const text=await resp.text();
    let j;
    try{ j=JSON.parse(text); }catch(e){ throw new Error('Resposta inválida do servidor: '+text); }
    if(!j.ok){ alert('Erro: '+(j.error||'Falha ao salvar')); return; }
    location.reload();
  }catch(e){
    console.error(e); alert('Falha na requisição: '+e.message);
  }
});

document.querySelectorAll('.btn-del').forEach(function(btn){
  btn.addEventListener('click',async function(){
    var tr=btn.closest('tr'); var id=tr.dataset.id;
    if(!confirm('Tem certeza que deseja apagar este lançamento?')) return;
    const resp=await fetch('delete.php',{method:'POST',body:formToFD({id:id})});
    const j=await resp.json();
    if(!j.ok){ alert('Erro: '+(j.error||'Falha ao apagar')); return; }
    tr.remove();
  });
});
</script>
</body>
</html>
