-- 1) Garante tabela contas
CREATE TABLE IF NOT EXISTS contas (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nome VARCHAR(100) NOT NULL UNIQUE,
  ativa TINYINT(1) NOT NULL DEFAULT 1,
  criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- 2) Adiciona coluna 'conta_id' (se faltar)
SET @col := (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME='lancamentos' AND COLUMN_NAME='conta_id');
SET @qry := IF(@col=0, 'ALTER TABLE lancamentos ADD COLUMN conta_id INT NULL, ADD INDEX conta_id (conta_id);', 'SELECT 1');
PREPARE stmt FROM @qry; EXECUTE stmt; DEALLOCATE PREPARE stmt;

-- 3) Adiciona coluna 'transferencia' (se faltar)
SET @col2 := (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME='lancamentos' AND COLUMN_NAME='transferencia');
SET @qry2 := IF(@col2=0, 'ALTER TABLE lancamentos ADD COLUMN transferencia TINYINT(1) NOT NULL DEFAULT 0, ADD INDEX transferencia (transferencia);', 'SELECT 1');
PREPARE stmt2 FROM @qry2; EXECUTE stmt2; DEALLOCATE PREPARE stmt2;

-- 4) Ajusta ENUM 'fonte' para incluir 'transfer'
SET @needs_enum := (
  SELECT IF(LOCATE('transfer', COLUMN_TYPE)=0, 1, 0)
  FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME='lancamentos' AND COLUMN_NAME='fonte' LIMIT 1
);
SET @qry3 := IF(@needs_enum=1, "ALTER TABLE lancamentos MODIFY COLUMN fonte ENUM('manual','whatsapp','transfer') NOT NULL DEFAULT 'manual';", 'SELECT 1');
PREPARE stmt3 FROM @qry3; EXECUTE stmt3; DEALLOCATE PREPARE stmt3;

-- 5) Cria tabela transferencias (se faltar)
CREATE TABLE IF NOT EXISTS transferencias (
  id INT AUTO_INCREMENT PRIMARY KEY,
  data DATE NOT NULL,
  de_conta_id INT NOT NULL,
  para_conta_id INT NOT NULL,
  valor DECIMAL(12,2) NOT NULL,
  descricao VARCHAR(255) NULL,
  criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  INDEX (data), INDEX (de_conta_id), INDEX (para_conta_id)
);
