<?php
require_once __DIR__ . '/config.php';
$pdo = db();

// Filtros
$ano  = isset($_GET['ano']) ? (int)$_GET['ano'] : (int)date('Y');
$mes  = isset($_GET['mes']) ? (int)$_GET['mes'] : (int)date('m');
$conta_id = (isset($_GET['conta_id']) && $_GET['conta_id']!=='') ? (int)$_GET['conta_id'] : null;
$dt_ini = isset($_GET['dt_ini']) ? $_GET['dt_ini'] : sprintf('%04d-01-01', $ano);
$dt_fim = isset($_GET['dt_fim']) ? $_GET['dt_fim'] : sprintf('%04d-12-31', $ano);

// Contas
$contas = $pdo->query("SELECT id,nome FROM contas WHERE ativa=1 ORDER BY nome")->fetchAll();
function contaNome($id, $contas){
  foreach($contas as $c){ if($c['id']==$id) return $c['nome']; }
  return '(Todas)';
}

// Helper para where de conta
$whereConta = $conta_id!==null ? " AND conta_id=".$conta_id : "";

// ---------------- Saldo por Conta (no período dt_ini..dt_fim) ----------------
$sqlSaldoConta = "SELECT conta_id,
  SUM(CASE WHEN tipo='receita' THEN valor ELSE 0 END) AS receitas,
  SUM(CASE WHEN tipo='despesa' THEN valor ELSE 0 END) AS despesas
FROM lancamentos
WHERE data BETWEEN ? AND ? {$whereConta}
GROUP BY conta_id
ORDER BY conta_id";
$st = $pdo->prepare($sqlSaldoConta);
$st->execute(array($dt_ini, $dt_fim));
$saldoConta = $st->fetchAll();

// ---------------- Entradas por Conta (receitas) ----------------
$sqlEntradasConta = "SELECT conta_id, SUM(valor) AS total_receitas
FROM lancamentos
WHERE tipo='receita' AND data BETWEEN ? AND ? {$whereConta}
GROUP BY conta_id ORDER BY conta_id";
$st2 = $pdo->prepare($sqlEntradasConta);
$st2->execute(array($dt_ini, $dt_fim));
$entradasConta = $st2->fetchAll();

// ---------------- Saldo por Dia (do mês selecionado do ano) ----------------
$inicioMes = sprintf('%04d-%02d-01', $ano, $mes);
$fimMes = date('Y-m-t', strtotime($inicioMes));
$sqlDia = "SELECT DATE(data) d,
  SUM(CASE WHEN tipo='receita' THEN valor ELSE -valor END) AS saldo
FROM lancamentos WHERE data BETWEEN ? AND ? {$whereConta}
GROUP BY DATE(data) ORDER BY DATE(data)";
$sd = $pdo->prepare($sqlDia); $sd->execute(array($inicioMes,$fimMes));
$porDia = $sd->fetchAll();

// ---------------- Saldo por Semana (do ano) ----------------
$sqlSem = "SELECT YEARWEEK(data, 3) AS yw,
  MIN(DATE(data)) AS semana_ini,
  MAX(DATE(data)) AS semana_fim,
  SUM(CASE WHEN tipo='receita' THEN valor ELSE -valor END) AS saldo
FROM lancamentos
WHERE YEAR(data)=? {$whereConta}
GROUP BY YEARWEEK(data, 3)
ORDER BY YEARWEEK(data, 3)";
$ss = $pdo->prepare($sqlSem); $ss->execute(array($ano));
$porSemana = $ss->fetchAll();

// ---------------- Saldo por Mês (do ano) ----------------
$sqlMes = "SELECT MONTH(data) AS m,
  SUM(CASE WHEN tipo='receita' THEN valor ELSE -valor END) AS saldo,
  SUM(CASE WHEN tipo='receita' THEN valor ELSE 0 END) AS receitas,
  SUM(CASE WHEN tipo='despesa' THEN valor ELSE 0 END) AS despesas
FROM lancamentos
WHERE YEAR(data)=? {$whereConta}
GROUP BY MONTH(data) ORDER BY MONTH(data)";
$sm = $pdo->prepare($sqlMes); $sm->execute(array($ano));
$porMes = $sm->fetchAll();

// Funções utilitárias de encoding simples
function js_array_pairs($rows, $colKey, $colVal, $contas){
  $labels = array(); $vals = array();
  foreach($rows as $r){
    $k = $r[$colKey];
    $nome = $k ? contaNome($k, $contas) : '(Sem conta)';
    $labels[] = $nome;
    $vals[] = (float)$r[$colVal];
  }
  return array($labels, $vals);
}
function js_array_series($rows, $colKey, $colVal){
  $labels = array(); $vals = array();
  foreach($rows as $r){
    $labels[] = $r[$colKey];
    $vals[] = (float)$r[$colVal];
  }
  return array($labels, $vals);
}

// Preparar dados JS
list($sc_labelsR, $sc_valsR) = js_array_pairs($saldoConta, 'conta_id', 'receitas', $contas);
list($sc_labelsD, $sc_valsD) = js_array_pairs($saldoConta, 'conta_id', 'despesas', $contas);
$sc_saldo = array(); for($i=0;$i<count($sc_valsR);$i++){ $sc_saldo[] = (float)$sc_valsR[$i] - (float)$sc_valsD[$i]; }

list($ec_labels, $ec_vals) = js_array_pairs($entradasConta, 'conta_id', 'total_receitas', $contas);

list($dia_labels, $dia_vals) = js_array_series($porDia, 'd', 'saldo');

// Semana: mostrar como "Wxx (dd/mm)"
$sem_labels = array(); $sem_vals = array();
foreach($porSemana as $r){
  $lbl = 'W'.substr($r['yw'], -2).' ('.date('d/m', strtotime($r['semana_ini'])).')';
  $sem_labels[] = $lbl;
  $sem_vals[] = (float)$r['saldo'];
}

// Mês
$mes_labels = array(); $mes_vals = array(); $mes_rec = array(); $mes_desp = array();
for($i=1;$i<=12;$i++){
  $mes_labels[] = sprintf('%02d/%04d', $i, $ano);
  $found = null;
  foreach($porMes as $r){ if((int)$r['m']===$i){ $found=$r; break; } }
  if($found){
    $mes_vals[] = (float)$found['saldo'];
    $mes_rec[]  = (float)$found['receitas'];
    $mes_desp[] = (float)$found['despesas'];
  }else{
    $mes_vals[] = 0; $mes_rec[] = 0; $mes_desp[] = 0;
  }
}
?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Relatórios Avançados</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<style>.mini{font-size:.9rem;color:#6c757d}</style>
</head>
<body class="bg-light">
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="mb-0">Relatórios Avançados</h1>
    <div class="d-flex gap-2">
      <a href="index.php" class="btn btn-secondary">← Lançamentos</a>
      <a href="transfers.php" class="btn btn-outline-secondary">Transferências</a>
      <a href="contas.php" class="btn btn-outline-secondary">Contas</a>
    </div>
  </div>

  <form class="row g-2 mb-3" method="get">
    <div class="col-auto">
      <label class="form-label">Conta</label>
      <select name="conta_id" class="form-select">
        <option value="">(Todas)</option>
        <?php foreach($contas as $c): ?>
          <option value="<?= (int)$c['id'] ?>" <?= $conta_id===(int)$c['id']?'selected':'' ?>><?= h($c['nome']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-auto">
      <label class="form-label">Ano</label>
      <input type="number" name="ano" class="form-control" value="<?= $ano ?>">
    </div>
    <div class="col-auto">
      <label class="form-label">Mês (para Saldo por Dia)</label>
      <select name="mes" class="form-select">
        <?php for($m=1;$m<=12;$m++): ?>
          <option value="<?= $m ?>" <?= $m==$mes?'selected':'' ?>><?= $m ?></option>
        <?php endfor; ?>
      </select>
    </div>
    <div class="col-auto">
      <label class="form-label">De</label>
      <input type="date" name="dt_ini" class="form-control" value="<?= h($dt_ini) ?>">
    </div>
    <div class="col-auto">
      <label class="form-label">Até</label>
      <input type="date" name="dt_fim" class="form-control" value="<?= h($dt_fim) ?>">
    </div>
    <div class="col-auto align-self-end">
      <button class="btn btn-primary">Atualizar</button>
    </div>
  </form>

  <div class="row g-3">
    <div class="col-lg-6">
      <div class="card h-100">
        <div class="card-header">Saldo por Conta <span class="mini">(<?= date('d/m/Y', strtotime($dt_ini)) ?> a <?= date('d/m/Y', strtotime($dt_fim)) ?>)</span></div>
        <div class="card-body">
          <canvas id="saldoConta"></canvas>
        </div>
      </div>
    </div>
    <div class="col-lg-6">
      <div class="card h-100">
        <div class="card-header">Entradas (Receitas) por Conta <span class="mini">(<?= date('d/m/Y', strtotime($dt_ini)) ?> a <?= date('d/m/Y', strtotime($dt_fim)) ?>)</span></div>
        <div class="card-body">
          <canvas id="entradasConta"></canvas>
        </div>
      </div>
    </div>

    <div class="col-lg-6">
      <div class="card h-100">
        <div class="card-header">Saldo por Dia <span class="mini">(<?= sprintf('%02d/%04d', $mes, $ano) ?>)</span></div>
        <div class="card-body"><canvas id="saldoDia"></canvas></div>
      </div>
    </div>
    <div class="col-lg-6">
      <div class="card h-100">
        <div class="card-header">Saldo por Semana <span class="mini">(Ano <?= $ano ?>)</span></div>
        <div class="card-body"><canvas id="saldoSemana"></canvas></div>
      </div>
    </div>

    <div class="col-12">
      <div class="card">
        <div class="card-header">Saldo por Mês <span class="mini">(Ano <?= $ano ?>)</span></div>
        <div class="card-body"><canvas id="saldoMes"></canvas></div>
      </div>
    </div>
  </div>
</div>

<script>
function makeChart(id, type, labels, datasets){
  const ctx = document.getElementById(id).getContext('2d');
  return new Chart(ctx, { type: type, data: { labels: labels, datasets: datasets } });
}

// Dados vindos do PHP (sem estilos específicos, Chart.js escolhe cores)
const scLabels = <?= json_encode($sc_labelsR) ?>;
const scReceitas = <?= json_encode($sc_valsR) ?>;
const scDespesas = <?= json_encode($sc_valsD) ?>;
const scSaldo = <?= json_encode($sc_saldo) ?>;

const ecLabels = <?= json_encode($ec_labels) ?>;
const ecVals = <?= json_encode($ec_vals) ?>;

const diaLabels = <?= json_encode($dia_labels) ?>;
const diaVals = <?= json_encode($dia_vals) ?>;

const semLabels = <?= json_encode($sem_labels) ?>;
const semVals = <?= json_encode($sem_vals) ?>;

const mesLabels = <?= json_encode($mes_labels) ?>;
const mesSaldo = <?= json_encode($mes_vals) ?>;
const mesRec = <?= json_encode($mes_rec) ?>;
const mesDesp = <?= json_encode($mes_desp) ?>;

// Gráficos
makeChart('saldoConta','bar', scLabels, [
  {label:'Receitas', data: scReceitas},
  {label:'Despesas', data: scDespesas},
  {label:'Saldo', data: scSaldo}
]);
makeChart('entradasConta','bar', ecLabels, [
  {label:'Receitas', data: ecVals}
]);
makeChart('saldoDia','line', diaLabels, [
  {label:'Saldo do dia', data: diaVals}
 ]);
makeChart('saldoSemana','line', semLabels, [
  {label:'Saldo por semana', data: semVals}
]);
makeChart('saldoMes','line', mesLabels, [
  {label:'Saldo', data: mesSaldo},
  {label:'Receitas', data: mesRec},
  {label:'Despesas', data: mesDesp}
]);
</script>
</body>
</html>
