<?php
require_once __DIR__ . '/config.php'; $pdo=db();
$contas = $pdo->query("SELECT id,nome FROM contas WHERE ativa=1 ORDER BY nome")->fetchAll();
$ano = isset($_GET['ano']) ? (int)$_GET['ano'] : (int)date('Y');
$conta_id = isset($_GET['conta_id']) && $_GET['conta_id']!=='' ? (int)$_GET['conta_id'] : null;

function contaNome($id,$contas){ foreach($contas as $c){ if($c['id']==$id) return $c['nome']; } return '(Todas)'; }

// Monta vetor 1..12 com receitas, despesas
$receitas = array_fill(1,12,0.0); $despesas = array_fill(1,12,0.0);
for ($m=1; $m<=12; $m++){
  $inicio = sprintf('%04d-%02d-01', $ano, $m);
  $fim = date('Y-m-t', strtotime($inicio));
  if ($conta_id!==null) {
    $sr = $pdo->prepare("SELECT COALESCE(SUM(valor),0) s FROM lancamentos WHERE tipo='receita' AND data BETWEEN ? AND ? AND conta_id=?");
    $sr->execute([$inicio,$fim,$conta_id]); $receitas[$m] = (float)$sr->fetch()['s'];
    $sd = $pdo->prepare("SELECT COALESCE(SUM(valor),0) s FROM lancamentos WHERE tipo='despesa' AND data BETWEEN ? AND ? AND conta_id=?");
    $sd->execute([$inicio,$fim,$conta_id]); $despesas[$m] = (float)$sd->fetch()['s'];
  } else {
    $sr = $pdo->prepare("SELECT COALESCE(SUM(valor),0) s FROM lancamentos WHERE tipo='receita' AND data BETWEEN ? AND ?");
    $sr->execute([$inicio,$fim]); $receitas[$m] = (float)$sr->fetch()['s'];
    $sd = $pdo->prepare("SELECT COALESCE(SUM(valor),0) s FROM lancamentos WHERE tipo='despesa' AND data BETWEEN ? AND ?");
    $sd->execute([$inicio,$fim]); $despesas[$m] = (float)$sd->fetch()['s'];
  }
}
$saldoMes = []; for($m=1;$m<=12;$m++){ $saldoMes[$m] = $receitas[$m] - $despesas[$m]; }
?><!doctype html><html lang="pt-br"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Relatórios</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
</head><body class="bg-light"><div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3"><h1 class="mb-0">Relatórios</h1><div class="d-flex gap-2"><a href="index.php" class="btn btn-secondary">← Lançamentos</a><a href="contas.php" class="btn btn-outline-secondary">Contas</a><a href="transfers.php" class="btn btn-outline-secondary">Transferências</a></div></div>

  <form class="row g-2 mb-3" method="get">
    <div class="col-auto"><label class="form-label">Conta</label>
      <select name="conta_id" class="form-select">
        <option value="">(Todas)</option>
        <?php foreach($contas as $c): ?>
          <option value="<?= (int)$c['id'] ?>" <?= $conta_id===(int)$c['id']?'selected':'' ?>><?= h($c['nome']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-auto"><label class="form-label">Ano</label><input type="number" name="ano" class="form-control" value="<?= $ano ?>"></div>
    <div class="col-auto align-self-end"><button class="btn btn-primary">Atualizar</button></div>
  </form>

  <div class="card mb-3"><div class="card-header">Resumo <?= h(contaNome($conta_id,$contas)) ?> — <?= $ano ?></div>
    <div class="card-body">
      <div class="row g-3">
        <div class="col-md-4">
          <div class="p-3 border rounded">
            <div class="text-muted">Receitas (ano)</div>
            <div class="fs-4 fw-bold">R$ <?= number_format(array_sum($receitas),2,',','.') ?></div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="p-3 border rounded">
            <div class="text-muted">Despesas (ano)</div>
            <div class="fs-4 fw-bold">R$ <?= number_format(array_sum($despesas),2,',','.') ?></div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="p-3 border rounded">
            <div class="text-muted">Saldo (ano)</div>
            <div class="fs-4 fw-bold">R$ <?= number_format(array_sum($receitas)-array_sum($despesas),2,',','.') ?></div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="card mb-3"><div class="card-header">Evolução Mensal</div>
    <div class="card-body">
      <canvas id="chart" height="120"></canvas>
    </div>
  </div>

  <div class="card"><div class="card-header">Tabela Mensal</div>
    <div class="table-responsive"><table class="table table-striped mb-0">
      <thead><tr><th>Mês</th><th>Receitas</th><th>Despesas</th><th>Saldo</th></tr></thead>
      <tbody>
        <?php for($m=1;$m<=12;$m++): ?>
          <tr>
            <td><?= sprintf('%02d/%04d',$m,$ano) ?></td>
            <td>R$ <?= number_format($receitas[$m],2,',','.') ?></td>
            <td>R$ <?= number_format($despesas[$m],2,',','.') ?></td>
            <td class="<?= $saldoMes[$m]>=0?'text-success':'text-danger' ?>">R$ <?= number_format($saldoMes[$m],2,',','.') ?></td>
          </tr>
        <?php endfor; ?>
      </tbody>
    </table></div>
  </div>
</div>
<script>
const labels = [...Array(12).keys()].map(i=>('0'+(i+1)).slice(-2));
const receitas = <?= json_encode(array_values($receitas)) ?>;
const despesas = <?= json_encode(array_values($despesas)) ?>;
const saldo = <?= json_encode(array_values($saldoMes)) ?>;
const ctx = document.getElementById('chart').getContext('2d');
new Chart(ctx, {
  type: 'line',
  data: {
    labels,
    datasets: [
      { label: 'Receitas', data: receitas },
      { label: 'Despesas', data: despesas },
      { label: 'Saldo', data: saldo }
    ]
  }
});
</script>
</body></html>
