CREATE TABLE IF NOT EXISTS contas (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nome VARCHAR(100) NOT NULL UNIQUE,
  ativa TINYINT(1) NOT NULL DEFAULT 1,
  criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS lancamentos (
  id INT AUTO_INCREMENT PRIMARY KEY,
  data DATE NOT NULL,
  descricao VARCHAR(255) NOT NULL,
  valor DECIMAL(12,2) NOT NULL,
  tipo ENUM('receita','despesa') NOT NULL,
  recorrente TINYINT(1) NOT NULL DEFAULT 0,
  conta_id INT NULL,
  transferencia TINYINT(1) NOT NULL DEFAULT 0,
  fonte ENUM('manual','whatsapp','transfer') NOT NULL DEFAULT 'manual',
  criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  atualizado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  INDEX (data), INDEX (tipo), INDEX (recorrente), INDEX (conta_id), INDEX (transferencia)
);

CREATE TABLE IF NOT EXISTS transferencias (
  id INT AUTO_INCREMENT PRIMARY KEY,
  data DATE NOT NULL,
  de_conta_id INT NOT NULL,
  para_conta_id INT NOT NULL,
  valor DECIMAL(12,2) NOT NULL,
  descricao VARCHAR(255) NULL,
  criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  INDEX (data), INDEX (de_conta_id), INDEX (para_conta_id)
);
