<?php
require_once __DIR__ . '/config.php'; $pdo=db();
$contas = $pdo->query("SELECT id,nome FROM contas WHERE ativa=1 ORDER BY nome")->fetchAll();
$erro=''; $ok='';

if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['add'])){
  $data = $_POST['data'] ?? date('Y-m-d');
  $de = (int)($_POST['de_conta_id'] ?? 0);
  $para = (int)($_POST['para_conta_id'] ?? 0);
  $valor = (float)str_replace(',', '.', $_POST['valor'] ?? '0');
  $desc = trim($_POST['descricao'] ?? '');

  if($de>0 && $para>0 && $de!=$para && $valor>0){
    try{
      $pdo->beginTransaction();
      $pdo->prepare("INSERT INTO transferencias (data,de_conta_id,para_conta_id,valor,descricao) VALUES (?,?,?,?,?)")->execute([$data,$de,$para,$valor,$desc]);
      $tId = $pdo->lastInsertId();
      // Busca nomes
      function nomeConta($id,$contas){ foreach($contas as $c){ if($c['id']==$id) return $c['nome']; } return ''; }
      $deNome = nomeConta($de,$contas); $paraNome = nomeConta($para,$contas);
      // Saída da conta origem (despesa)
      $pdo->prepare("INSERT INTO lancamentos (data,descricao,valor,tipo,recorrente,conta_id,fonte,transferencia) VALUES (?,?,?,?,0,?, 'transfer', 1)")->execute([$data, 'Transferência para '.$paraNome.($desc?(' — '.$desc):''), $valor, 'despesa', $de]);
      // Entrada na conta destino (receita)
      $pdo->prepare("INSERT INTO lancamentos (data,descricao,valor,tipo,recorrente,conta_id,fonte,transferencia) VALUES (?,?,?,?,0,?, 'transfer', 1)")->execute([$data, 'Transferência de '.$deNome.($desc?(' — '.$desc):''), $valor, 'receita', $para]);
      $pdo->commit();
      $ok = 'Transferência registrada.';
    }catch(Exception $e){ $pdo->rollBack(); $erro='Erro: '.$e->getMessage(); }
  }else{
    $erro = 'Preencha os campos corretamente (contas diferentes e valor > 0).';
  }
}

$recents = $pdo->query("SELECT t.*, c1.nome de_nome, c2.nome para_nome FROM transferencias t LEFT JOIN contas c1 ON c1.id=t.de_conta_id LEFT JOIN contas c2 ON c2.id=t.para_conta_id ORDER BY t.data DESC, t.id DESC LIMIT 50")->fetchAll();
?><!doctype html><html lang="pt-br"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Transferências</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body class="bg-light"><div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3"><h1 class="mb-0">Transferências</h1><div class="d-flex gap-2"><a href="index.php" class="btn btn-secondary">← Lançamentos</a><a href="contas.php" class="btn btn-outline-secondary">Contas</a><a href="reports.php" class="btn btn-outline-secondary">Relatórios</a></div></div>
  <?php if($erro): ?><div class="alert alert-danger"><?= h($erro) ?></div><?php endif; ?>
  <?php if($ok): ?><div class="alert alert-success"><?= h($ok) ?></div><?php endif; ?>

  <div class="card mb-3"><div class="card-header">Nova Transferência</div><div class="card-body">
    <form method="post" class="row g-2">
      <div class="col-md-2"><label class="form-label">Data</label><input type="date" name="data" class="form-control" value="<?= date('Y-m-d') ?>"></div>
      <div class="col-md-3"><label class="form-label">De</label><select name="de_conta_id" class="form-select" required><?php foreach($contas as $c): ?><option value="<?= (int)$c['id'] ?>"><?= h($c['nome']) ?></option><?php endforeach; ?></select></div>
      <div class="col-md-3"><label class="form-label">Para</label><select name="para_conta_id" class="form-select" required><?php foreach($contas as $c): ?><option value="<?= (int)$c['id'] ?>"><?= h($c['nome']) ?></option><?php endforeach; ?></select></div>
      <div class="col-md-2"><label class="form-label">Valor</label><input name="valor" class="form-control" placeholder="100,00" required></div>
      <div class="col-md-12"><label class="form-label">Descrição (opcional)</label><input name="descricao" class="form-control" placeholder="ex.: reserva, ajuste, etc."></div>
      <div class="col-auto"><button class="btn btn-success mt-2" name="add" value="1">Lançar Transferência</button></div>
    </form>
  </div></div>

  <div class="card"><div class="card-header">Últimas 50 Transferências</div>
    <div class="table-responsive"><table class="table table-striped mb-0 align-middle">
      <thead><tr><th>Data</th><th>De</th><th>Para</th><th>Valor</th><th>Descrição</th></tr></thead><tbody>
        <?php foreach($recents as $r): ?>
          <tr>
            <td><?= date('d/m/Y', strtotime($r['data'])) ?></td>
            <td><?= h($r['de_nome']) ?></td>
            <td><?= h($r['para_nome']) ?></td>
            <td>R$ <?= number_format((float)$r['valor'],2,',','.') ?></td>
            <td><?= h($r['descricao']) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody></table></div>
  </div>
</div></body></html>
