<?php
require_once __DIR__ . '/config.php';
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(array('ok'=>false, 'error'=>'Método inválido'));
    exit;
}

$id         = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$data       = isset($_POST['data']) ? $_POST['data'] : '';
$descricao  = isset($_POST['descricao']) ? trim($_POST['descricao']) : '';
$valor_raw  = isset($_POST['valor']) ? trim($_POST['valor']) : '';
$tipo       = (isset($_POST['tipo']) && $_POST['tipo'] === 'receita') ? 'receita' : 'despesa';
$recorrente = (isset($_POST['recorrente']) && $_POST['recorrente'] == '1') ? 1 : 0;
$conta_id   = (isset($_POST['conta_id']) && $_POST['conta_id'] !== '') ? (int)$_POST['conta_id'] : null;

if ($id <= 0 || $data === '' || $descricao === '' || $valor_raw === '') {
    echo json_encode(array('ok'=>false, 'error'=>'Dados inválidos'));
    exit;
}

$valor_norm = str_replace(array('.',' '), array('',''), $valor_raw);
$valor_norm = str_replace(',', '.', $valor_norm);
if (!is_numeric($valor_norm)) {
    echo json_encode(array('ok'=>false, 'error'=>'Valor inválido'));
    exit;
}

try {
    $pdo = db();
    $sql = 'UPDATE lancamentos SET data=?, descricao=?, valor=?, tipo=?, recorrente=?, conta_id=? WHERE id=?';
    $stmt = $pdo->prepare($sql);
    $stmt->execute(array(
        $data,
        mb_substr($descricao, 0, 255, 'UTF-8'),
        (float)$valor_norm,
        $tipo,
        $recorrente,
        $conta_id,
        $id
    ));
    echo json_encode(array('ok'=>true));
} catch (Exception $e) {
    echo json_encode(array('ok'=>false, 'error'=>$e->getMessage()));
}
?>