
CREATE TABLE usuarios(
 id INT AUTO_INCREMENT PRIMARY KEY,
 nome VARCHAR(100),
 email VARCHAR(100) UNIQUE,
 senha_hash VARCHAR(255),
 perfil ENUM('ADMIN','OPERADOR'),
 status ENUM('ativo','inativo') DEFAULT 'ativo'
);

CREATE TABLE clientes(
 id INT AUTO_INCREMENT PRIMARY KEY,
 nome VARCHAR(150),
 codigo_cliente VARCHAR(50) UNIQUE,
 percentual_desconto DECIMAL(5,2),
 status ENUM('ativo','inativo')
);

CREATE TABLE contas(
 id INT AUTO_INCREMENT PRIMARY KEY,
 cliente_id INT,
 mes_referencia VARCHAR(7),
 valor_acres_band_amarela DECIMAL(10,2) DEFAULT 0
);

CREATE TABLE tarifas_kwh(
 id INT AUTO_INCREMENT PRIMARY KEY,
 mes_referencia VARCHAR(7),
 valor_kwh DECIMAL(10,4)
);

CREATE TABLE vencimentos(
 id INT AUTO_INCREMENT PRIMARY KEY,
 mes_referencia VARCHAR(7),
 data_vencimento DATE
);

INSERT INTO usuarios(nome,email,senha_hash,perfil)
VALUES('Admin','admin@admin.com',
'$2y$10$abcdefghijklmnopqrstuvabcdefghijklmnopqrstuvabcdefghijklmno','ADMIN');
